<?php

if(!class_exists('Slick_Menu_License_Manager')) {

    require_once 'class-license.php';

    class Slick_Menu_License_Manager {

        #region Singleton
        private static $_instance;

        public $license;
        public $updater;
        public $product;
        public $market_product;
        public $is_last_version;

        private function __construct($product)
        {

            $this->product = $product;
            $this->market_product = (object)$product->markets[$product->market];

            $this->is_last_version = !empty($this->market_product->last_version) && version_compare($this->product->version, $this->market_product->last_version, '>=');

            if(empty($this->license) || !$this->license instanceof Slick_Menu_License) {

                $this->license = new Slick_Menu_License($this);
            }

            if($this->is_last_version) {
                add_action('admin_notices', array($this, 'last_codecanyon_version'));
            }

            if(!empty($_REQUEST['xt-license-revoke']) && !empty($_REQUEST['id'])) {

                $id = intval($_REQUEST['id']);

                if($this->market_product->id === $id) {

                    $license = new Slick_Menu_License( $this );

                    $purchase_code = $license->getLocalLicenseInfo( 'purchase_code' );
                    $domain        = $license->getLocalLicenseInfo( 'domain' );

                    if ( ! empty( $purchase_code ) ) {
                        $license->revoke( $purchase_code, $domain );
                    }

                    $license->deleteLocalLicense();
                    die();
                }
            }

            if(is_admin()) {

                $this->updater = new Slick_Menu_Plugin_Updater($this->license, $this->product, $this->is_last_version );
            }

            return $this;
        }

        function last_codecanyon_version() {
            return;


            if(!Slick_Menu()->backend()->welcome->is_welcome_page()) {
                return;
            }

            $message = __('<strong>Slick Menu</strong> plugin has retired from CodeCanyon and will now be sold exclusively on XplodedThemes.com.<br><span style="color:green;"><strong>To continue receiving new updates and security patches, please migrate your CodeCanyon license.</strong></span>', 'slick-menu');
            $button = sprintf(__('<a target="_blank" class="button button-secondary" href="https://xplodedthemes.com/codecanyon-license-migration/?id=%d"><strong>Migrate License</strong></a>', 'slick-menu'), $this->product->freemius_id);
            ?>
            <br clear="all"/>
            <div class="slickmenu-notice notice notice-warning">
                <p>
                    <span class="slickmenu-notice-col-left"><?php echo $message;?></span>
                    <span class="slickmenu-notice-col-right"><?php echo $button;?></span>
                </p>
            </div>
            <?php
        }

        public static function instance($product)
        {
            if (!isset(self::$_instance)) {
                self::$_instance = new self($product);
            }
            return self::$_instance;
        }
        #endregion

        /**
         * Check if running premium plugin code.

         * @since  1.0.5
         *
         * @return bool
         */
        function is_premium() {
            return true;
        }

        /**
         * Check if the user has an activated and valid paid license on current plugin's install.
         *
         * @return bool
         */
        function is_paying_active() {
            return $this->is_paying() && $this->license->isActivated();
        }

        /**
         * Check if the user has a valid paid license on current plugin's install.
         *
         * @return bool
         */
        function is_paying() {
            return $this->license->isFound();
        }

        /**
         * Check if user in trial or in free plan (not paying).
         *
         * @return bool
         */
        function is_not_paying() {
            return ( $this->is_trial() || $this->is_free_plan() );
        }

        /**
         * Check if the user is paying or in trial.
         *
         * @return bool
         */
        function is_paying_or_trial() {
            return ( $this->is_paying() || $this->is_trial() );
        }

        /**
         * Check if user in a trial or have feature enabled license.

         * @return bool
         */
        function can_use_premium_code() {
            return $this->is_paying();
        }

        #----------------------------------------------------------------------------------
        #region Premium Only
        #----------------------------------------------------------------------------------

        /**
         * Returns true when running premium plugin code.
         *
         * @return bool
         */
        function is__premium_only() {
            return $this->is_premium();
        }

        /**
         * Check if the user has an activated and valid paid license on current plugin's install.
         *
         * @return bool
         *
         */
        function is_paying__premium_only() {
            return ( $this->is__premium_only() && $this->is_paying() );
        }

        /**
         * Check if the user is paying or in trial.
         *
         * All code wrapped in this statement will be only included in the premium code.
         *
         *
         * @return bool
         */
        function is_paying_or_trial__premium_only() {
            return $this->is_premium() && $this->is_paying_or_trial();
        }


        /**
         * Check if user in a trial or have feature enabled license.
         *
         * All code wrapped in this statement will be only included in the premium code.
         *
         * @return bool
         */
        function can_use_premium_code__premium_only() {
            return $this->is_premium() && $this->can_use_premium_code();
        }

        #endregion

        #----------------------------------------------------------------------------------
        #region Trial
        #----------------------------------------------------------------------------------

        /**
         * Check if the user in a trial.
         *
         * @return bool
         */
        function is_trial() {
            return false;
        }

        /**
         * Check if trial already utilized.
         *
         *
         * @return bool
         */
        function is_trial_utilized() {
            return false;
        }

        #endregion

        #----------------------------------------------------------------------------------
        #region Plans
        #----------------------------------------------------------------------------------

        /**
         * Check if the user is on the free plan of the product.
         *
         * @return bool
         */
        function is_free_plan() {
            return false;
        }

        /**
         * Check if module has any release on Freemius,
         * or all plugin's code is on WordPress.org (Serviceware).
         *
         * @return bool
         */
        function has_release_on_freemius() {
            return false;
        }

        /**
         * Checks if it's a freemium plugin.
         *
         * @return bool
         */
        function is_freemium() {
            return false;
        }

        /**
         * Get plugin's upgrade URL.
         *
         * @return bool
         */
        function get_upgrade_url() {

            if(!empty($this->market_product->url)) {
                return $this->market_product->url;
            }

            return '';
        }

        /**
         * Get plugin's license URL.
         *
         * @return string
         */
        function get_account_url( $action = false, $params = array(), $add_action_nonce = true ) {

            if(!empty($this->product->license_section_slug)) {
                return admin_url('admin.php?page='.$this->product->license_section_slug);
            }

            return '';
        }

        #----------------------------------------------------------------------------------
        #dummy freemius wrapper functions to avoid errors
        #----------------------------------------------------------------------------------

        function add_action($tag, $function_to_add, $priority = 10, $accepted_args = 1) {

            add_action($tag, $function_to_add, $priority, $accepted_args);
        }

        function add_filter($tag, $function_to_add, $priority = 10, $accepted_args = 1) {

            add_filter($tag, $function_to_add, $priority, $accepted_args);
        }

        function apply_filters($tag, $value) {

            return apply_filters($tag, $value);
        }
    }
}